% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{race_mirai}
\alias{race_mirai}
\title{mirai (Race)}
\usage{
race_mirai(x)
}
\arguments{
\item{x}{a 'mirai' object, or list of 'mirai' objects.}
}
\value{
The passed object (invisibly).
}
\description{
Accepts a list of 'mirai' objects, such as those returned by \code{\link[=mirai_map]{mirai_map()}}.
Waits for the next 'mirai' to resolve if at least one is still in progress,
blocking but user-interruptible. If none of the objects supplied are
unresolved, the function returns immediately.
}
\details{
All of the 'mirai' objects supplied must belong to the same compute profile -
the currently-active one i.e. 'default' unless within a \code{\link[=with_daemons]{with_daemons()}} or
\code{\link[=local_daemons]{local_daemons()}} scope.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
daemons(2)
m1 <- mirai(Sys.sleep(0.2))
m2 <- mirai(Sys.sleep(0.1))
start <- Sys.time()
race_mirai(list(m1, m2))
Sys.time() - start
race_mirai(list(m1, m2))
Sys.time() - start
daemons(0)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=call_mirai]{call_mirai()}}
}
