% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{muscle}
\alias{muscle}
\title{Multiple alignment using MUSCLE}
\usage{
muscle(
  in.file,
  out.file,
  muscle.exe = "muscle",
  quiet = FALSE,
  diags = FALSE,
  maxiters = 16
)
}
\arguments{
\item{in.file}{Name of FASTA file with input sequences.}

\item{out.file}{Name of file to store the result.}

\item{muscle.exe}{Command to run the external software muscle on the system (text).}

\item{quiet}{Logical, \code{quiet = FALSE} produces screen output during computations.}

\item{diags}{Logical, \code{diags = TRUE} gives faster but less reliable alignment.}

\item{maxiters}{Maximum number of iterations.}
}
\value{
The result is written to the file specified in \code{out.file}.
}
\description{
Computing a multiple sequence alignment using the MUSCLE software.
}
\details{
The software MUSCLE (Edgar, 2004) must be installed and available on the system. The text in
\code{muscle.exe} must contain the exact command to invoke muscle on the system.

By default \code{diags = FALSE} but can be set to \code{TRUE} to increase speed. This should be done
only if sequences are highly similar.

By default \code{maxiters = 16}. If you have a large number of sequences (a few thousand), or they are 
very long, then this may be too slow for practical use. A good compromise between speed and accuracy
is to run just the first two iterations of the algorithm. On average, this gives accuracy equal to
T-Coffee and speeds much faster than CLUSTALW. This is done by the option \code{maxiters = 2}.
}
\examples{
\dontrun{
fa.file <- file.path(file.path(path.package("microseq"),"extdata"),"small.faa")
muscle(in.file = fa.file, out.file = "delete_me.msa")
}

}
\references{
Edgar, R.C. (2004). MUSCLE: multiple sequence alignment with high accuracy and high 
throughput, Nucleic Acids Res, 32, 1792-1797.
}
\seealso{
\code{\link{msaTrim}}.
}
\author{
Lars Snipen.
}
