% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{findrRNA}
\alias{findrRNA}
\title{Finding rRNA genes}
\usage{
findrRNA(genome, barrnap.exe = "barrnap", bacteria = TRUE, cpu = 1)
}
\arguments{
\item{genome}{A table with columns Header and Sequence, containing the genome sequence(s).}

\item{barrnap.exe}{Command to run the external software barrnap on the system (text).}

\item{bacteria}{Logical, the genome is either a bacteria (default) or an archea.}

\item{cpu}{Number of CPUs to use, default is 1.}
}
\value{
A GFF-table (see \code{\link{readGFF}} for details) with one row for each detected
rRNA sequence.
}
\description{
Finding rRNA genes in genomic DNA using the barrnap software.
}
\details{
The external software barrnap is used to scan through a prokaryotic genome to detect the
rRNA genes (5S, 16S, 23S).
The text in \code{barrnap.exe} must contain the exact command to invoke barrnap on the system.
}
\examples{
\dontrun{
# This example requires the external barrnap software
# Using a genome file in this package.
genome.file <- file.path(path.package("microseq"),"extdata","small.fna")

# Searching for rRNA sequences, and inspecting
genome <- readFasta(genome.file)
gff.tbl <- findrRNA(genome)
print(gff.table)

# Retrieving the sequences
rRNA <- gff2fasta(gff.tbl, genome)
}

}
\seealso{
\code{\link{readGFF}}, \code{\link{gff2fasta}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
