% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_align.R
\name{gen_feat_mat}
\alias{gen_feat_mat}
\title{Generate Feature Matrix.}
\usage{
gen_feat_mat(
  data_path,
  ppm_range = get_ppm_range(data_path),
  si_size_real_spectrum = length(data_path$y_values),
  scale_factor_x = 1000,
  warn = TRUE
)
}
\arguments{
\item{data_path}{A list of deconvoluted spectra as returned by
\code{generate_lorentz_curves()}. In older versions, this could also be the path
passed to \code{generate_lorentz_curves()}, but this is deprecated and will
trigger a warning. See 'Details' for more information.}

\item{ppm_range}{The ppm range over which your signals are distributed.}

\item{si_size_real_spectrum}{Number of data points in your spectra.}

\item{scale_factor_x}{The x scale factor used during the deconvolution.}

\item{warn}{Whether to print a warning in case a file path is passed to
\code{data_path} instead of a list of deconvoluted spectra.}
}
\value{
A list with the following elements:

\code{data_matrix}: A data.frame where each row corresponds to one spectrum and
each column to one data point, i.e. for 10 input spectra
with 131072 data points each \code{data_matrix} would have
dimensions 10 x 131072.

\code{peakList}: A list of vectors, where each vector contains the indices of
the peaks in the corresponding spectrum. The indices increase
from left to right, i.e. the smallest index corresponds to the
highest ppm value, as the ppm values decrease from left to
right.

\code{w}: A list of vectors where each vector contains the "position parameter"
of the peaks in the corresponding spectrum.

\code{A}: A list of vectors where each vector contains the "area parameter" of
the peaks in the corresponding spectrum.

\code{lambda}: A list of vectors where each vector contains the "width
parameter" of the peaks in the corresponding spectrum.
}
\description{
Generate a feature matrix.
}
\details{
Before version 1.2 of 'metabodecon', the deconvolution functions
\code{generate_lorentz_curves} and \code{MetaboDecon1D} wrote their output partially as
txt files to their input folder. Back then, \code{gen_feat_mat()} used those txt
files as input to generate the feature matrix. Since version 1.2 these txt
files are no longer created by default, to prevent accidental modifications
of the input folders. Therefore, the recommended way to pass the required
information to \code{gen_feat_mat()} is to directly pass the output of
\code{generate_lorentz_curves()} to \code{gen_feat_mat()}. However, to stay backwards
compatible, the name of parameter \code{data_path} was not changed and passing an
actual path to \code{data_path} is still possible, but will result in a warning
(unless \code{warn} is set to \code{FALSE}).
}
\examples{
sim_subset <- metabodecon_file("sim_subset")
decons <- generate_lorentz_curves_sim(sim_subset)
obj <- gen_feat_mat(decons)
str(obj, 2, give.attr = FALSE)
}
\author{
Initial version from Wolfram Gronwald.
Refactored by Tobias Schmidt in 2024.
}
