% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{client}
\alias{client}
\alias{mcp_tools}
\alias{mcp_client}
\title{R as a client: Define ellmer tools from MCP servers}
\usage{
mcp_tools(config = NULL)
}
\arguments{
\item{config}{A single string indicating the path to the mcptools MCP servers
configuration file. If one is not supplied, mcptools will look for one at
the file path configured with the option \code{.mcptools_config}, falling back to
\code{file.path("~", ".config", "mcptools", "config.json")}.}
}
\value{
\itemize{
\item \code{mcp_tools()} returns a list of ellmer tools that can be passed directly
to the \verb{$set_tools()} method of an \link[ellmer:Chat]{ellmer::Chat} object. If the file at
\code{config} doesn't exist, an error.
}
}
\description{
These functions implement R as an MCP \emph{client}, so that ellmer chats can
register functionality from third-party MCP servers such as those listed
here: \url{https://github.com/modelcontextprotocol/servers}.

\code{mcp_tools()} fetches tools from MCP servers configured in the mcptools
server config file and converts them to a list of
tools compatible with the \verb{$set_tools()} method of \link[ellmer:Chat]{ellmer::Chat} objects.
}
\section{Configuration}{


mcptools uses the same .json configuration file format as Claude Desktop;
most MCP servers will define example .json to configure the server with
Claude Desktop in their README files. By default, mcptools will look to
\code{file.path("~", ".config", "mcptools", "config.json")}; you can edit that
file with \code{file.edit(file.path("~", ".config", "mcptools", "config.json"))}.

The mcptools config file should be valid .json with an entry \code{mcpServers}.
That entry should contain named elements, each with at least a \code{command}
and \code{args} entry.

For example, to configure \code{mcp_tools()} with GitHub's official MCP Server
\url{https://github.com/github/github-mcp-server}, you could write the following
in that file:

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
  "mcpServers": \{
    "github": \{
      "command": "docker",
      "args": [
        "run",
        "-i",
        "--rm",
        "-e",
        "GITHUB_PERSONAL_ACCESS_TOKEN",
        "ghcr.io/github/github-mcp-server"
      ],
      "env": \{
        "GITHUB_PERSONAL_ACCESS_TOKEN": "<add_your_github_pat_here>"
      \}
    \}
  \}
\}
}\if{html}{\out{</div>}}
}

\examples{
# setup
config_file <- tempfile(fileext = "json")
file.create(config_file)

# usually, `config` would be a persistent, user-level
# configuration file for a set of MCP server
mcp_tools(config = config_file)

# teardown
file.remove(config_file)


}
\seealso{
This function implements R as an MCP \emph{client}. To use R as an MCP \emph{server},
i.e. to provide apps like Claude Desktop or Claude Code with access to
R-based tools, see \code{\link[=mcp_server]{mcp_server()}}.
}
