% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVG.R
\name{BVN_Gibbs}
\alias{BVN_Gibbs}
\title{MCMC samples from a bivariate normal distribution}
\usage{
BVN_Gibbs(n, mu, sigma)
}
\arguments{
\item{n}{Sample size of the Markov chain.}

\item{mu}{A 2 dimensional vector. Mean of the target normal distribution.}

\item{sigma}{2 x 2 symmetric positive definite matrix. The covariance matrix of the target normal distribution.}
}
\value{
An n x 2 matrix of the Gibbs samples.
}
\description{
Function returns Gibbs samples from a bivariate normal target density.
}
\examples{
n <- 1e3
mu <- c(2, 50)
sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)
out <- BVN_Gibbs(n, mu, sigma)

}
