% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{maximize_log_lh_p}
\alias{maximize_log_lh_p}
\title{Maximise the log-likelihood or log-posterior as defined by a sampler closure}
\usage{
maximize_log_lh_p(
  sampler,
  type = c("llh", "lpost"),
  method = "BFGS",
  control = list(fnscale = -1),
  ...
)
}
\arguments{
\item{sampler}{sampler function closure, i.e. the return value of a call to \code{\link{create_sampler}}.}

\item{type}{either "llh" (default) or "lpost", for optimization of the log-likelihood,
or the log-posterior, respectively.}

\item{method}{optimization method, passed to \code{\link[stats]{optim}}.}

\item{control}{control parameters, passed to \code{\link[stats]{optim}}.}

\item{...}{other parameters passed to \code{\link[stats]{optim}}.}
}
\value{
A list of parameter values that, provided the optimisation was successful, maximize the (log-)likelihood
 or (log-)posterior.
}
\description{
Maximise the log-likelihood or log-posterior as defined by a sampler closure
}
\examples{
\donttest{
n <- 1000
dat <- data.frame(
  x = rnorm(n),
  f = factor(sample(1:50, n, replace=TRUE))
)
df <- generate_data(
  ~ reg(~x, name="beta", prior=pr_normal(precision=1)) + gen(~x, factor=~f, name="v"),
  family=f_gaussian(var.prior=pr_fixed(value=1)), data=dat
)
dat$y <- df$y
sampler <- create_sampler(y ~ x + gen(~x, factor=~f, name="v"), data=dat)
opt <- maximize_log_lh_p(sampler)
str(opt)
plot(df$par$v, opt$par$v); abline(0, 1, col="red")
}

}
