% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle.R
\name{circle}
\alias{circle}
\title{Draw circles on an existing plot.}
\usage{
circle(
  x,
  y,
  radius,
  nv = 60,
  border = NULL,
  col = NA,
  lty = 1,
  density = NULL,
  angle = 45,
  lwd = 1
)
}
\arguments{
\item{x, y}{Coordinates of the center of the circle. If \code{x} is a vector of length 2, \code{y} is ignored and the
center is taken as \code{x[1], x[2]}.}

\item{radius}{Radius (or radii) of the circle(s) in user units.}

\item{nv}{Number of vertices to draw the circle.}

\item{border}{Color to use for drawing the circumference. \code{\link[graphics]{polygon}}}

\item{col}{Color to use for filling the circle.}

\item{lty}{Line type for the circumference.}

\item{density}{Density for patterned fill. See \code{\link[graphics]{polygon}}.}

\item{angle}{Angle of patterned fill. See \code{\link[graphics]{polygon}}.}

\item{lwd}{Line width for the circumference.}
}
\value{
Invisibly returns a list with the \code{x} and \code{y} coordinates of the points on the circumference of the last circle displayed.
}
\description{
Draw circles on an existing plot.
}
\details{
Rather than depending on the aspect ratio \code{par("asp")} set globally or
in the call to \code{\link[base]{plot}},
\code{circle} uses the dimensions of the current plot and the \code{x} and \code{y} coordinates to draw a circle rather than an ellipse.
Of course, if you resize the plot the aspect ratio can change.

This function was copied from \code{\link[plotrix]{draw.circle}}
}
\examples{
plot(1:5,seq(1,10,length=5),
     type="n",xlab="",ylab="",
     main="Test draw.circle")
# draw three concentric circles
circle(2, 4, c(1, 0.66, 0.33),border="purple",
            col=c("#ff00ff","#ff77ff","#ffccff"),lty=1,lwd=1)
# draw some others
circle(2.5, 8, 0.6,border="red",lty=3,lwd=3)
circle(4, 3, 0.7,border="green",col="yellow",lty=1,
            density=5,angle=30,lwd=10)
circle(3.5, 8, 0.8,border="blue",lty=2,lwd=2)
}
\seealso{
\code{\link[graphics]{polygon}}
}
\author{
Jim Lemon, thanks to David Winsemius for the density and angle args
}
