% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{validate_mass_props_unc}
\alias{validate_mass_props_unc}
\title{Validate mass properties uncertainties}
\usage{
validate_mass_props_unc(mp)
}
\arguments{
\item{mp}{Mass properties and uncertainties list containing the following named elements
\itemize{
\item \code{point} Logical indicating point mass, i.e., negligible inertia
\item \code{sigma_mass} mass uncertainty
\item \code{sigma_center_mass} center of mass uncertainty (3-dimensional numeric)
\item \code{sigma_inertia} Inertia tensor uncertainty (3x3 numeric matrix)
}}
}
\value{
TRUE if valid, stops otherwise
}
\description{
\code{validate_mass_props_unc()} ensures that a mass properties and uncertainties
list satisfies the following constraints:
\itemize{
\item \code{sigma_mass} is non-missing and non-negative
\item \code{sigma_center_mass} is a 3-vector of non-missing non-negative values
\item if \code{point} is FALSE, the \code{sigma_inertia} contains no missing or negative values
}
}
\examples{
mp <- get_mass_props_and_unc(sawe_table, "Widget")
validate_mass_props_unc(mp)

}
