% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{combine_mass_props_and_unc}
\alias{combine_mass_props_and_unc}
\title{Combine mass properties and uncertainties}
\usage{
combine_mass_props_and_unc(mpl)
}
\arguments{
\item{mpl}{A list of mass properties and uncertainties lists, each of which contains
the following named elements:
\itemize{
\item \code{mass} Numeric mass.
\item \code{center_mass} Numeric 3-vector center of mass.
\item \code{point} Logical indicating point mass. The inertia of point masses is excluded from calculations.
\item \code{inertia} Numeric 3x3 matrix inertia tensor.
\item \code{sigma_mass} mass uncertainty
\item \code{sigma_center_mass} center of mass uncertainty (3-dimensional numeric)
\item \code{sigma_inertia} Inertia tensor uncertainty (3x3 numeric matrix)
}}
}
\value{
Combined mass properties list with the same named elements.
}
\description{
\code{combine_mass_props_and_unc()} is a convenience wrapper that concatenates the
results of \code{combine_mass_props()} and \code{combine_mass_props_unc()}.
}
\examples{
leaves <- names(igraph::neighbors(sawe_tree, "Combined", mode = "in"))
mpl <- Map(f = function(id) get_mass_props_and_unc(sawe_table, id), leaves)
combine_mass_props_and_unc(mpl)

}
