% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewRGB.R
\docType{methods}
\name{viewRGB}
\alias{viewRGB}
\alias{viewRGB,RasterStackBrick-method}
\title{Red-Green-Blue map view of a multi-layered Raster object}
\usage{
viewRGB(
  x,
  r = 3,
  g = 2,
  b = 1,
  quantiles = c(0.02, 0.98),
  map = NULL,
  maxpixels = mapviewGetOption("mapview.maxpixels"),
  map.types = mapviewGetOption("basemaps"),
  na.color = mapviewGetOption("na.color"),
  layer.name = NULL,
  method = c("bilinear", "ngb"),
  ...
)
}
\arguments{
\item{x}{a RasterBrick, RasterStack}

\item{r}{integer. Index of the Red channel/band, between 1 and nlayers(x)}

\item{g}{integer. Index of the Green channel/band, between 1 and nlayers(x)}

\item{b}{integer. Index of the Blue channel/band, between 1 and nlayers(x)}

\item{quantiles}{the upper and lower quantiles used for color stretching. If set to NULL, no stretching is applied.}

\item{map}{the map to which the layer should be added}

\item{maxpixels}{integer > 0. Maximum number of cells to use for the plot.
If maxpixels < \code{ncell(x)}, sampleRegular is used before plotting.}

\item{map.types}{character spcifications for the base maps.
see \url{https://leaflet-extras.github.io/leaflet-providers/preview/}
for available options.}

\item{na.color}{the color to be used for NA pixels}

\item{layer.name}{the name of the layer to be shown on the map}

\item{method}{Method used to compute
values for the resampled layer that is passed on to leaflet. mapview does
projection on-the-fly to ensure correct display and therefore needs to know
how to do this projection. The default is 'bilinear' (bilinear interpolation),
which is appropriate for continuous variables. The other option, 'ngb'
(nearest neighbor), is useful for categorical variables.}

\item{...}{additional arguments passed on to \code{\link{mapView}}}
}
\description{
Make a Red-Green-Blue plot based on three layers (in a RasterBrick, RasterStack).
Three layers (sometimes referred to as "bands" because they may represent
different bandwidths in the electromagnetic spectrum) are combined such
that they represent the red, green and blue channel. This function can
be used to make 'true (or false) color images' from Landsat and other
multi-band satellite images. Note, this text is plagiarized, i.e. copied
from \code{\link[raster:plotRGB]{raster::plotRGB()}}.
}
\examples{
if (interactive()) {
  library(raster)
  library(plainview)

  viewRGB(plainview::poppendorf, 4, 3, 2) # true-color
  viewRGB(plainview::poppendorf, 5, 4, 3) # false-color
}

}
\author{
Tim Appelhans
}
