% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapshot.R
\name{removeMapJunk}
\alias{removeMapJunk}
\title{Delete elements from a map.}
\usage{
removeMapJunk(map, junk = NULL)
}
\arguments{
\item{map}{the map from which to remove elements.}

\item{junk}{a charcter vector of elements to remove. If NULL (the default),
nothing is removed and the map is returned as is. See Details for a list
of currently supported elements.}
}
\description{
Delete elements from a map.
}
\details{
Currently supports removal of

\itemize{
  \item "zoomControl"
  \item "layersControl"
  \item "homeButton"
  \item "scaleBar"
  \item "drawToolbar"
  \item "easyButton"
}

This is mainly useful when taking a static screenshot of a map.
}
\examples{
if (interactive()) {
  library(mapview)

  map = mapview(franconia)

  removeMapJunk(map, "zoomControl")
}

}
