% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{clear_legend}
\alias{clear_legend}
\title{Clear legends from a map}
\usage{
clear_legend(map, legend_ids = NULL)
}
\arguments{
\item{map}{A map proxy object created by \code{mapboxgl_proxy()} or \code{maplibre_proxy()}.}

\item{legend_ids}{Optional. A character vector of legend IDs to clear. If not provided, all legends will be cleared.}
}
\value{
The updated map proxy object with the specified legend(s) cleared.
}
\description{
Remove one or more legends from a Mapbox GL or MapLibre GL map in a Shiny application.
}
\note{
This function can only be used with map proxy objects in Shiny applications.
It cannot be used with static map objects.
}
\examples{
\dontrun{
# In a Shiny server function:

# Clear all legends
observeEvent(input$clear_all, {
  mapboxgl_proxy("map") \%>\%
    clear_legend()
})

# Clear specific legends by ID
observeEvent(input$clear_specific, {
  mapboxgl_proxy("map") \%>\%
    clear_legend(legend_ids = c("legend-1", "legend-2"))
})

# Clear legend after removing a layer
observeEvent(input$remove_layer, {
  mapboxgl_proxy("map") \%>\%
    remove_layer("my_layer") \%>\%
    clear_legend(legend_ids = "my_layer_legend")
})
}
}
