% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_boot_out.R
\name{print.boot_out}
\alias{print.boot_out}
\title{Print a \code{boot_out}-Class
Object}
\usage{
\method{print}{boot_out}(x, ...)
}
\arguments{
\item{x}{The output of \code{\link[=do_boot]{do_boot()}},
or any \code{boot_out}-class object
returned
by similar functions.}

\item{...}{Other arguments. Not
used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of the
output of \code{\link[=do_boot]{do_boot()}} or related
functions.
}
\examples{

data(data_med_mod_ab1)
dat <- data_med_mod_ab1
lm_m <- lm(m ~ x*w + c1 + c2, dat)
lm_y <- lm(y ~ m*w + x + c1 + c2, dat)
lm_out <- lm2list(lm_m, lm_y)
# In real research, R should be 2000 or even 5000
# In real research, no need to set parallel to FALSE
# In real research, no need to set progress to FALSE
# Progress is displayed by default.
lm_boot_out <- do_boot(lm_out, R = 100,
                       seed = 1234,
                       progress = FALSE,
                       parallel = FALSE)
# Print the output of do_boot()
lm_boot_out

library(lavaan)
data(data_med_mod_ab1)
dat <- data_med_mod_ab1
dat$"x:w" <- dat$x * dat$w
dat$"m:w" <- dat$m * dat$w
mod <-
"
m ~ x + w + x:w + c1 + c2
y ~ m + w + m:w + x + c1 + c2
"
fit <- sem(model = mod, data = dat, fixed.x = FALSE,
           se = "none", baseline = FALSE)
# In real research, R should be 2000 or even 5000
# In real research, no need to set progress to FALSE
# In real research, no need to set parallel to FALSE
# Progress is displayed by default.
fit_boot_out <- do_boot(fit = fit,
                        R = 40,
                        seed = 1234,
                        parallel = FALSE,
                        progress = FALSE)
# Print the output of do_boot()
fit_boot_out

}
