% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{luz_callback_train_valid}
\alias{luz_callback_train_valid}
\title{Train-eval callback}
\usage{
luz_callback_train_valid()
}
\value{
A \code{luz_callback}
}
\description{
Switches important flags for training and evaluation modes.
}
\details{
It takes care of the three \code{ctx} attributes:
\itemize{
\item \code{ctx$model}: Responsible for calling \code{ctx$model$train()} and \code{ctx$model$eval()},
when appropriate.
\item \code{ctx$training}: Sets this flag to \code{TRUE} when training and \code{FALSE} when in
validation mode.
\item \code{ctx$loss}: Resets the \code{loss} attribute to \code{list()} when finished training/ or
validating.
}
}
\note{
In general you won't need to explicitly use the metrics callback as it's
used by default in \code{\link[=fit.luz_module_generator]{fit.luz_module_generator()}}.
}
\seealso{
Other luz_callbacks: 
\code{\link{luz_callback_auto_resume}()},
\code{\link{luz_callback_csv_logger}()},
\code{\link{luz_callback_early_stopping}()},
\code{\link{luz_callback_interrupt}()},
\code{\link{luz_callback_keep_best_model}()},
\code{\link{luz_callback_lr_scheduler}()},
\code{\link{luz_callback_metrics}()},
\code{\link{luz_callback_mixup}()},
\code{\link{luz_callback_model_checkpoint}()},
\code{\link{luz_callback_profile}()},
\code{\link{luz_callback_progress}()},
\code{\link{luz_callback_resume_from_checkpoint}()},
\code{\link{luz_callback}()}
}
\concept{luz_callbacks}
