% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module.R
\name{evaluate}
\alias{evaluate}
\title{Evaluates a fitted model on a dataset}
\usage{
evaluate(
  object,
  data,
  ...,
  metrics = NULL,
  callbacks = list(),
  accelerator = NULL,
  verbose = NULL,
  dataloader_options = NULL
)
}
\arguments{
\item{object}{A fitted model to evaluate.}

\item{data}{(dataloader, dataset or list) A dataloader created with
\code{\link[torch:dataloader]{torch::dataloader()}} used for training the model, or a dataset created
with \code{\link[torch:dataset]{torch::dataset()}} or a list. Dataloaders and datasets must return a
list with at most 2 items. The first item will be used as input for the
module and the second will be used as a target for the loss function.}

\item{...}{Currently unused.}

\item{metrics}{A list of luz metrics to be tracked during evaluation. If \code{NULL}
(default) then the same metrics that were used during training are tracked.}

\item{callbacks}{(list, optional) A list of callbacks defined with
\code{\link[=luz_callback]{luz_callback()}} that will be called during the training procedure. The
callbacks \code{\link[=luz_callback_metrics]{luz_callback_metrics()}}, \code{\link[=luz_callback_progress]{luz_callback_progress()}} and
\code{\link[=luz_callback_train_valid]{luz_callback_train_valid()}} are always added by default.}

\item{accelerator}{(accelerator, optional) An optional \code{\link[=accelerator]{accelerator()}} object
used to configure device placement of the components like \link{nn_module}s,
optimizers and batches of data.}

\item{verbose}{(logical, optional) An optional boolean value indicating if
the fitting procedure should emit output to the console during training.
By default, it will produce output if \code{\link[=interactive]{interactive()}} is \code{TRUE}, otherwise
it won't print to the console.}

\item{dataloader_options}{Options used when creating a dataloader. See
\code{\link[torch:dataloader]{torch::dataloader()}}. \code{shuffle=TRUE} by default for the training data and
\code{batch_size=32} by default. It will error if not \code{NULL} and \code{data} is
already a dataloader.}
}
\description{
Evaluates a fitted model on a dataset
}
\details{
Once a model has been trained you might want to evaluate its performance
on a different dataset. For that reason, luz provides the \code{?evaluate}
function that takes a fitted model and a dataset and computes the
metrics attached to the model.

Evaluate returns a \code{luz_module_evaluation} object that you can query for
metrics using the \code{get_metrics} function or simply \code{print} to see the
results.

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{evaluation <- fitted \%>\% evaluate(data = valid_dl)
metrics <- get_metrics(evaluation)
print(evaluation)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## A `luz_module_evaluation`
## -- Results ---------------------------------------------------------------------
## loss: 1.5146
## mae: 1.0251
## mse: 1.5159
## rmse: 1.2312
}\if{html}{\out{</div>}}
}
\seealso{
Other training: 
\code{\link{fit.luz_module_generator}()},
\code{\link{predict.luz_module_fitted}()},
\code{\link{setup}()}
}
\concept{training}
