% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_key.R
\name{check_key}
\alias{check_key}
\title{Check and Prepare a Column Key Object}
\usage{
check_key(key = NULL)
}
\arguments{
\item{key}{(dataframe) key object including a "source", "raw_name" and "tidy_name" column. Additional columns are allowed but ignored}
}
\value{
(dataframe) key object with only "source", "raw_name" and "tidy_name" columns and only retains rows where a "tidy_name" is specified.
}
\description{
Accepts a column key dataframe and checks to make sure it has the needed structure for \code{ltertools::harmonize}. Also removes unnecessary columns and rows that lack a "tidy_name". Function invoked 'under the hood' by \code{ltertools::harmonize}.
}
\examples{
# Generate a column key object manually
key_obj <- data.frame("source" = c(rep("df1.csv", 3), 
                                   rep("df2.csv", 3)),
                      "raw_name" = c("xx", "unwanted", "yy",
                                     "LETTERS", "NUMBERS", "BONUS"),
                    "tidy_name" = c("numbers", NA, "letters",
                                    "letters", "numbers", "kingdom"))

# Check it
ltertools::check_key(key = key_obj)

}
