% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcdf_parse.R
\name{df_to_netcdf}
\alias{df_to_netcdf}
\title{Convert Data Frame to NetCDF}
\usage{
df_to_netcdf(
  df,
  output_file,
  lat_var = "lat",
  lon_var = "lon",
  global_atts = list(),
  units = list(),
  longnames = list(),
  cf_standard_names = list()
)
}
\arguments{
\item{df}{A data frame containing the data to be converted.}

\item{output_file}{The path to the output NetCDF file.}

\item{lat_var}{The name of the latitude variable in the data frame. Default is "lat".}

\item{lon_var}{The name of the longitude variable in the data frame. Default is "lon".}

\item{global_atts}{A list of global attributes to add to the NetCDF file. Default is an empty list.}

\item{units}{A list of units for each variable in the data frame. Default is an empty list.}

\item{longnames}{A list of long names for each variable in the data frame. Default is an empty list.}

\item{cf_standard_names}{A list of CF standard names for each variable in the data frame. Default is an empty list.}
}
\value{
None. The function writes the data to a NetCDF file.
}
\description{
This function converts a data frame to a NetCDF file for a list of points (rows are different stations).
It attempts to identify CF-compliant coordinate variables, such as latitude and longitude, using default or specified column names.
}
\examples{
# Example data frame
example_df <- data.frame(
  lat = c(-35.0, -34.5, -34.0),
  lon = c(150.0, 150.5, 151.0),
  variable1 = c(0.1, 0.2, 0.3),
  variable2 = c(0.4, 0.5, 0.6)
)

# Define units, longnames, and CF standard names
units_list <- list(variable1 = "m", variable2 = "cm")
longnames_list <- list(variable1 = "Variable 1 Longname",
                       variable2 = "Variable 2 Longname")
cf_standard_names_list <- list(variable1 = "sea_surface_height",
                                variable2 = "sea_water_temperature")
tf <- tempfile("test.nc")
# Convert example data frame to NetCDF
df_to_netcdf(example_df, tf, global_atts = list(
  title = "Example NetCDF",
  summary = "This is a test NetCDF file created from an example data frame.",
  source = "Example data",
  references = "N/A"
), units = units_list, longnames = longnames_list,
  cf_standard_names = cf_standard_names_list)

}
