% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{pgpd}
\alias{pgpd}
\alias{dgpd}
\alias{hgpd}
\alias{qgpd}
\title{Distribution function of the generalized Pareto distribution}
\usage{
pgpd(q, loc = 0, scale = 1, shape = 0, lower.tail = TRUE, log.p = FALSE)

dgpd(x, loc = 0, scale = 1, shape = 0, log = FALSE)

hgpd(x, loc = 0, scale = 1, shape = 0, log = FALSE)

qgpd(p, loc = 0, scale = 1, shape = 0, lower.tail = TRUE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{loc}{location parameter.}

\item{scale}{scale parameter, strictly positive.}

\item{shape}{shape parameter.}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{log.p}{logical; if \code{FALSE} (default), values are returned on the probability scale.}

\item{x}{vector of quantiles.}

\item{log}{logical; if \code{FALSE} (default), return the log hazard}

\item{p}{vector of probabilities.}
}
\value{
a vector of (log)-probabilities of the same length as \code{q}

a vector of (log)-density.

a vector of (log)-hazard.

a vector of quantiles
}
\description{
Distribution function of the generalized Pareto distribution

Density function of the generalized Pareto distribution

Hazard function of the generalized Pareto distribution

Quantile function of the generalized Pareto distribution
}
\keyword{internal}
