% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{plot.litfit_bootstrap}
\alias{plot.litfit_bootstrap}
\title{Plot the bootstrap distribution for a parameter from a litfit object}
\usage{
\method{plot}{litfit_bootstrap}(x,coef.index,bw,...)
}
\arguments{
\item{x}{litfit object}

\item{coef.index}{coefficient number to plot from the \code{litfit} object, see order of coefficients for that particular model.  Default is to plot the first parameter for that model}

\item{bw}{bandwidth (or bandwidth algorithm see \code{\link{density}}) for the density plot}

\item{...}{additional arguments passed to plot.default}
}
\value{
plot of litfit_bootstrap object, returns invisibly
}
\description{
Plot a bootstrap distribution of a particular coefficient
}
\details{
The grey fill goes from 0.025 quantile to the 0.975 quantile of the distribution.  Red line shows the mean.  Blue line shows the median.
}
\examples{
fit <- fit_litter(time=pineneedles$Year,
mass.remaining=pineneedles$Mass.remaining, model='neg.exp', iters=200)
boot1 <- bootstrap_parameters(fit, nboot = 500)
plot(boot1)

}
\seealso{
\code{\link{fit_litter}} \code{\link{bootstrap_parameters}} \code{\link{density}}
}
\author{
James Weedon
}
