% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-axis-dendro.R
\name{guide_axis_dendro}
\alias{guide_axis_dendro}
\title{Dendrogram guide}
\usage{
guide_axis_dendro(
  key = "dendro",
  title = waiver(),
  theme = NULL,
  labels = TRUE,
  space = rel(10),
  vanish = TRUE,
  n.dodge = 1,
  angle = waiver(),
  check.overlap = FALSE,
  ticks = "none",
  axis_line = "none",
  order = 0,
  position = waiver()
)
}
\arguments{
\item{key}{A \link[=key_segments]{segment key} specification. See more information
in the linked topic. Alternatively, an object of class
\code{\link[stats:hclust]{<hclust>}} that automatically invokes \code{key_dendro()}.}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{labels, ticks, axis_line}{Guides to use as labels, ticks or axis lines. Can be specified as one of
the following:
\itemize{
\item A \verb{<logical[1]>} which when \code{FALSE} will set the guide to \code{guide_none()}
and if \code{TRUE}, will set guide to appropriate primitive.
\item A \verb{<Guide>} class object.
\item A \verb{<function>} that returns a \verb{<Guide>} class object.
\item A \verb{<character[1]>} naming such a function, without the \code{guide_} or
\code{primitive_} prefix.
}}

\item{space}{Either a \code{\link[grid:unit]{<unit>}} or \code{\link[ggplot2:element]{<rel>}}
object of length 1 determining the space allocated in the orthogonal
direction. When the \code{space} argument is of class \verb{<rel>} (default) the
base size is taken from the tick length theme setting.}

\item{vanish}{Only relevant when the guide is used in the secondary theta
position: a \verb{<logical[1]>} on whether the continue to draw the segments
until they meed in the center (\code{TRUE}) or strictly observe the \code{space}
setting (\code{FALSE}).}

\item{n.dodge}{An positive \verb{<integer[1]>} setting the number of layers text
labels can occupy to avoid overlapping labels.}

\item{angle}{A specification for the text angle. Compared to setting the \code{angle} argument
in \code{\link[ggplot2:element]{element_text()}}, this argument uses some
heuristics to automatically pick the \code{hjust} and \code{vjust} that you
probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take angles and justification settings directly from the theme.
\item \code{\link[ggplot2:waiver]{waiver()}} to allow reasonable defaults in special
cases.
\item A \verb{<numeric[1]>} between -360 and 360 for the text angle in degrees.
}}

\item{check.overlap}{A \verb{<logical[1]>} indicating whether to check for and
omit overlapping text. If \code{TRUE}, first, last and middle labels are
recursively prioritised in that order. If \code{FALSE}, all labels are drawn.}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \verb{<Guide>} object.
}
\description{
This axis is a speciality axis for discrete data that has been
hierarchically clustered. Please be aware that the guide cannot affect the
scale limits, which should be set appropriately. This guide will give
misleading results when this step is skipped!
}
\examples{
# Hierarchically cluster data
clust <- hclust(dist(scale(mtcars)), "ave")

# Using the guide along with appropriate limits
p <- ggplot(mtcars, aes(disp, rownames(mtcars))) +
  geom_col() +
  scale_y_discrete(limits = clust$labels[clust$order])

# Standard usage
p + guides(y = guide_axis_dendro(clust))

# Adding ticks and axis line
p + guides(y = guide_axis_dendro(clust, ticks = "ticks", axis_line = "line")) +
  theme(axis.line = element_line())

# Controlling space allocated to dendrogram
p + guides(y = guide_axis_dendro(clust, space = unit(4, "cm"))) +
  theme(axis.ticks.y.left = element_line("red"))

# If want just the dendrogram, use `labels = FALSE`
p + guides(y = guide_axis_dendro(clust, labels = FALSE), y.sec = "axis")
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_base}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_circles}()},
\code{\link{guide_colbar}()},
\code{\link{guide_colring}()},
\code{\link{guide_colsteps}()},
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_cross}()},
\code{\link{guide_legend_group}()}
}
\concept{standalone guides}
