% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-crux.R
\name{compose_crux}
\alias{compose_crux}
\title{Compose guides in a cross}
\usage{
compose_crux(
  key = NULL,
  centre = "none",
  left = "none",
  right = "none",
  top = "none",
  bottom = "none",
  args = list(),
  complete = FALSE,
  theme = NULL,
  theme_defaults = list(),
  reverse = FALSE,
  order = 0,
  title = waiver(),
  position = waiver(),
  available_aes = NULL
)
}
\arguments{
\item{key}{A \link[=key_standard]{standard key} specification. The key is shared
among all guides that have \code{NULL} keys themselves. See more information
in the linked topic.}

\item{centre, left, right, top, bottom}{Guides to use in
\link[=guide-composition]{composition} per position. Each guide can be
specified as one of the following:
\itemize{
\item A \verb{<Guide>} class object.
\item A \verb{<function>} that returns a \verb{<Guide>} class object.
\item A \verb{<character>} naming such a function, without the \code{guide_} or
\code{primitive_} prefix.
}}

\item{args}{A \verb{<list>} of arguments to pass to guides that are given either
as a function or as a string.}

\item{complete}{A \verb{<logical[1]>} whether to treat the composition as a
complete guide. If \code{TRUE}, a title and margin are added to the result.
If \code{FALSE} (default), no titles and margins are added.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide
individually of differently from the plot's theme settings. The \code{theme}
arguments in the guide overrides, and is combined with, the plot's theme.}

\item{theme_defaults}{A \verb{<list>} of theme elements to override undeclared
theme arguments.}

\item{reverse}{A \verb{<logical[1]>} whether to reverse continuous guides.
If \code{TRUE}, guides like colour bars are flipped. If \code{FALSE} (default),
the original order is maintained.}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{position}{Where this guide should be drawn: one of \code{"top"}, \code{"bottom"},
\code{"left"}, or \code{"right"}.}

\item{available_aes}{A \verb{<character>} vector listing the aesthetics for which this guide can
be build.}
}
\value{
A \verb{<ComposeCrux>} guide object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This guide composition has a central guide optionally surrounded by other
guides on all four sides.
}
\examples{
# Roughly recreating a colour bar with extra text on top and bottom
crux <- compose_crux(
  centre = gizmo_barcap(), left = "axis_base",
  right = "axis_base",
  top = primitive_title("A lot"),
  bottom = primitive_title("A little")
)

ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = cty)) +
  guides(colour = crux)
}
\seealso{
Other composition: 
\code{\link{compose_ontop}()},
\code{\link{compose_sandwich}()},
\code{\link{compose_stack}()},
\code{\link{guide-composition}}
}
\concept{composition}
