% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-colbar.R
\name{guide_colbar}
\alias{guide_colbar}
\title{Custom colour bar guide}
\usage{
guide_colbar(
  title = waiver(),
  key = "auto",
  first_guide = "axis_base",
  second_guide = first_guide,
  shape = "triangle",
  size = NULL,
  show = NA,
  nbin = 15,
  alpha = NA,
  reverse = FALSE,
  oob = scales::oob_keep,
  theme = NULL,
  vanilla = TRUE,
  position = waiver(),
  available_aes = c("colour", "fill")
)
}
\arguments{
\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{key}{A \link[=key_sequence]{sequence key} specification. Defaults to
\code{\link[=key_sequence]{key_sequence(n = 15)}}. Changing the argument to
\code{key_sequence()} is fine, but changing the key type is not advised.}

\item{first_guide, second_guide}{Guides to flank the colour bar. Each guide
can be specified using one of the following:
\itemize{
\item A \verb{<Guide>} class object.
\item A \verb{<function>} that returns a \verb{<Guide>} class object.
\item A \verb{<character>} naming such a function, without the \code{guide_} or
\code{primitive_} prefix.
}

The \code{first_guide} will be placed at the location specified by the
\code{legend.text.position} theme setting. The \code{second_guide} will be placed
opposite that position. When \code{second_guide} has a label suppression
mechanism, no labels will be drawn for that guide.}

\item{shape}{A \link[=cap_options]{cap} specification by providing one of the
following:
\itemize{
\item A cap \verb{<function>}, such as \code{cap_triangle()}.
\item A \verb{<character[1]>} naming a cap function without the '\code{cap_}'-prefix,
e.g. \code{"round"}.
\item A two column \verb{<matrix[n, 2]>} giving coordinates for a cap, like those
created by cap functions such as \code{cap_arch()}.
}}

\item{size}{A \code{\link[grid:unit]{<unit>}} setting the size of the cap. When
\code{NULL} (default), cap size will be proportional to the \code{shape} coordinates
and the \code{legend.key.size} theme setting.}

\item{show}{A \verb{<logical>} to control how caps are displayed at the ends
of the bar. When \code{TRUE}, caps are always displayed. When \code{FALSE}, caps
are never displayed. When \code{NA} (default), caps are displayed when the
data range exceed the limits. When given as \verb{<logical[2]>}, \code{show[1]}
controls the display at the lower end and \code{show[2]} at the upper end.}

\item{nbin}{A positive \verb{<integer[1]>} determining how many colours to use
for the colour gradient.}

\item{alpha}{A \verb{<numeric[1]>} between 0 and 1 setting the colour transparency
of the bar. Use \code{NA} to preserve the alpha encoded in the colour itself.}

\item{reverse}{A \verb{<logical[1]>} whether to reverse continuous guides.
If \code{TRUE}, guides like colour bars are flipped. If \code{FALSE} (default),
the original order is maintained.}

\item{oob}{An out-of-bounds handling function that affects the cap colour.
Can be one of the following:
\itemize{
\item A \verb{<function>} like \code{\link[scales:oob]{oob_squish}}.
\item A \verb{<character[1]>} naming such a function without the '\code{oob}'-prefix,
such as \code{"keep"}.
}}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{vanilla}{A \verb{<logical[1]>} whether to have the default style match
the vanilla \code{guide_colourbar()} (\code{TRUE}) or take the theme
verbatim (\code{FALSE}).}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{available_aes}{A \verb{<character>} vector listing the aesthetics for which this guide can
be build.}
}
\value{
A \verb{<Guide>} object
}
\description{
Similar to \code{\link[ggplot2:guide_colourbar]{guide_colourbar()}}, this guide
displays continuous \code{colour} or \code{fill} aesthetics. It has additional options
to display caps at the end of the bar, depending on out-of-bounds values.
}
\details{
As colours are always rendered as gradients, it is important to use a
graphics device that can render these. This can be checked by using
\code{\link[ggplot2:check_device]{check_device("gradients")}}.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = cty))

# The colourbar shows caps when values are out-of-bounds (oob)
p + scale_colour_viridis_c(
  limits = c(10, NA),
  guide = "colbar"
)

# It also shows how oob values are handled
p + scale_colour_viridis_c(
  limits = c(10, NA), oob = scales::oob_squish,
  guide = "colbar"
)

# Adjusting the type of cap
p + scale_colour_viridis_c(
  limits = c(10, 30), oob = scales::oob_squish,
  guide = guide_colbar(shape = "round")
)

# One-sided ticks
p + scale_colour_viridis_c(
  guide = guide_colbar(second_guide = "none")
)

# Colour bar with minor breaks
p + scale_colour_viridis_c(
  minor_breaks = scales::breaks_width(1),
  guide = guide_colbar(key = "minor")
)

# Using log ticks on a colourbar
ggplot(msleep, aes(sleep_total, sleep_rem)) +
  geom_point(aes(colour = bodywt), na.rm = TRUE) +
  scale_colour_viridis_c(
    transform = "log10",
    guide = guide_colbar(key = "log")
  )
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_base}()},
\code{\link{guide_axis_dendro}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_circles}()},
\code{\link{guide_colring}()},
\code{\link{guide_colsteps}()},
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_cross}()},
\code{\link{guide_legend_group}()}
}
\concept{standalone guides}
