% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan_cov.R
\name{lavaan_cov}
\alias{lavaan_cov}
\alias{lavaan_cor}
\title{Extract relevant covariance/correlation indices from lavaan model}
\usage{
lavaan_cov(fit, nice_table = FALSE, ...)

lavaan_cor(fit, nice_table = FALSE, ...)
}
\arguments{
\item{fit}{lavaan fit object to extract covariance indices from}

\item{nice_table}{Logical, whether to print the table as a
\link[rempsyc:nice_table]{rempsyc::nice_table} as well as print the
reference values at the bottom of the table.}

\item{...}{Arguments to be passed to \link[rempsyc:nice_table]{rempsyc::nice_table}}
}
\value{
A dataframe of covariances/correlation, including the covaried
variables, the covariance/correlation, and corresponding p-value.
}
\description{
Extract relevant covariance/correlation indices from lavaan
\link[lavaan:parameterEstimates]{lavaan::parameterEstimates} and \link[lavaan:standardizedSolution]{lavaan::standardizedsolution}.
}
\section{Functions}{
\itemize{
\item \code{lavaan_cor()}: Shortcut for \code{lavaan_cov(fit, estimate = "r")}

}}
\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
x <- paste0("x", 1:9)
(latent <- list(
  visual = x[1:3],
  textual = x[4:6],
  speed = x[7:9]
))

(regression <- list(
  ageyr = c("visual", "textual", "speed"),
  grade = c("visual", "textual", "speed")
))

(covariance <- list(speed = "textual", ageyr = "grade"))

HS.model <- write_lavaan(
  regression = regression, covariance = covariance,
  latent = latent, label = TRUE
)
cat(HS.model)

library(lavaan)
fit <- sem(HS.model, data = HolzingerSwineford1939)
lavaan_cov(fit)
\dontshow{\}) # examplesIf}
}
