% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/model.R
\name{predictForCluster}
\alias{predictForCluster}
\alias{predictForCluster,lcModel-method}
\title{Predict trajectories conditional on cluster membership}
\usage{
predictForCluster(object, newdata = NULL, cluster, ...)

\S4method{predictForCluster}{lcModel}(object, newdata = NULL, cluster, ..., what = "mu")
}
\arguments{
\item{object}{The model.}

\item{newdata}{A \code{data.frame} of trajectory data for which to compute trajectory assignments.}

\item{cluster}{The cluster name (as \code{character}) to predict for.}

\item{...}{
  Arguments passed on to \code{\link[=predict.lcModel]{predict.lcModel}}
  \describe{
    \item{\code{useCluster}}{Whether to use the "Cluster" column in the newdata argument for computing predictions conditional on the respective cluster.
For \code{useCluster = NA} (the default), the feature is enabled if newdata contains the "Cluster" column.}
  }}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}
}
\value{
A \code{vector} with the predictions per \code{newdata} observation, or a \code{data.frame} with the predictions and newdata alongside.
}
\description{
Predicts the expected trajectory observations at the given time under the assumption that the trajectory belongs to the specified cluster.

For \code{lcModel} objects, the same result can be obtained by calling \code{\link[=predict.lcModel]{predict()}} with the \code{newdata} \code{data.frame} having a \code{"Cluster"} assignment column.
The main purpose of this function is to make it easier to implement the prediction computations for custom \code{lcModel} classes.
}
\details{
The default \code{predictForCluster(lcModel)} method makes use of \code{\link[=predict.lcModel]{predict.lcModel()}}, and vice versa. For this to work, any extending \code{lcModel} classes, e.g., \code{lcModelExample}, should implement either \code{predictForCluster(lcModelExample)} or \code{predict.lcModelExample()}. When implementing new models, it is advisable to implement \code{predictForCluster} as the cluster-specific computation generally results in shorter and simpler code.
}
\section{Implementation}{

Classes extending \code{lcModel} should override this method, unless \code{\link[=predict.lcModel]{predict.lcModel()}} is preferred.
\preformatted{
setMethod("predictForCluster", "lcModelExt",
 function(object, newdata = NULL, cluster, ..., what = "mu") {
  # return model predictions for the given data under the
  # assumption of the data belonging to the given cluster
})
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)

predictForCluster(
  model,
  newdata = data.frame(Time = c(0, 1)),
  cluster = "B"
)

# all fitted values under cluster B
predictForCluster(model, cluster = "B")
}
\seealso{
\link{predict.lcModel}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
