% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamin_cli.R
\name{lamin_login}
\alias{lamin_login}
\title{Log into LaminDB}
\usage{
lamin_login(user = NULL, api_key = NULL)
}
\arguments{
\item{user}{Handle for the user to login as}

\item{api_key}{API key for a user}
}
\description{
Log in as a LaminDB user
}
\details{
Depending on the input, one of these commands will be run (in this order):
\enumerate{
\item If \code{user} is set then \verb{lamin login <user>}
\item Else if \code{api_key} is set then set the \code{LAMIN_API_KEY} environment variable
temporarily with \code{withr::with_envvar()} and run \verb{lamin login}
\item Else if there is a stored user handle run \verb{lamin login <handle>}
\item Else if the \code{LAMIN_API_KEY} environment variable is set run \verb{lamin login}
}

Otherwise, exit with an error
}
