% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{update_input}
\alias{update_input}
\title{Update an Input Control with Column Names}
\usage{
update_input(
  control,
  id,
  x,
  choices = colnames,
  exclude = reactive(NULL),
  select = TRUE,
  placeholder = FALSE
)
}
\arguments{
\item{control}{An UI input updater.}

\item{id}{A \code{\link{character}} string specifying the namespace.}

\item{x}{A reactive \code{matrix}-like object.}

\item{choices}{A \code{\link{function}} that takes \code{x} as a single argument and returns
a \code{character} vector.}

\item{exclude}{A reactive \code{\link{character}} vector of values to be excluded from
choices.}

\item{select}{A \code{\link{logical}} scalar: should all choices be selected?}

\item{placeholder}{A \code{\link{logical}} scalar: should a placeholder be added?}
}
\value{
A reactive \code{\link{character}} vector of column names.

Side effect: change the value of an input control on the client.
}
\description{
Update an Input Control with Column Names
}
\seealso{
\code{\link[=update_checkbox_colnames]{update_checkbox_colnames()}}, \code{\link[=update_selectize_colnames]{update_selectize_colnames()}},
\code{\link[=update_selectize_rownames]{update_selectize_rownames()}}
}
\keyword{internal}
