% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_url_bullet.R
\name{jpinfect_url_bullet}
\alias{jpinfect_url_bullet}
\title{Display Infectious Diseases Weekly Report (IDWR) URLs}
\usage{
jpinfect_url_bullet(year = NULL, week = 1:53, language = "en")
}
\arguments{
\item{year}{An integer specifying the year of the data. Must be provided explicitly and should be after 2021.}

\item{week}{A numeric vector specifying the weeks to display URLs for (default is 1:53).
Week numbers should be between 1 and 53.}

\item{language}{A character string specifying the language of the data ('en' for English, 'jp' for Japanese).
Default is 'en'.}
}
\value{
A character vector of constructed URLs for the specified weeks and language. If the data
        is not available for certain weeks, a message is displayed, and those weeks are skipped.
}
\description{
This function displays the URLs of Infectious Diseases Weekly Report (IDWR)
from the Japan Institute for Health Security (JIHS) for a specified year and weeks, based on
the chosen language (English or Japanese).
See this webpage for further details: https://id-info.jihs.go.jp/
}
\details{
- The function constructs URLs for each week using the IDWR data source for the specified language.
- The year must be explicitly provided and must be greater than 2023.
- Week numbers must be valid (1 to 53), otherwise an error is raised.
- If the IDWR data is not available for a particular week, a warning is displayed, and that week is skipped.
- Progress updates are provided in the console using `message()`.
}
\examples{
\donttest{
# Display URLs for English data for weeks 1 to 5 in 2025
jpinfect_url_bullet(year = 2025, week = 1:5, language = "en")

# Display URLs for Japanese data for all weeks in 2025
jpinfect_url_bullet(year = 2025, language = "jp")

# Display URLs for English data for weeks 10 to 20 in 2024
jpinfect_url_bullet(year = 2024, week = 10:20, language = "en")
}

}
