% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_read_confirmed.R
\name{.jpinfect_read_excel}
\alias{.jpinfect_read_excel}
\title{Process a Single Excel File}
\usage{
.jpinfect_read_excel(file_path, year = NULL, sheet_range = NULL)
}
\arguments{
\item{file_path}{A character string specifying the path to the Excel file.}

\item{year}{An optional integer specifying the year of the data. If NULL, the year is inferred from the file name.}

\item{sheet_range}{A vector of integers specifying the sheet range to process. If NULL, it is inferred based on the year.}
}
\value{
A data frame containing processed case reports from the specified file.
}
\description{
This internal function processes a single Excel file containing case reports. The function dynamically
adapts to the structure of the file based on its type and year.
}
\details{
The function reads data from the specified sheet range using \code{read_excel}. It handles specific data formatting
for \code{"sex"} and \code{"place"} datasets based on file patterns and column structures.

Supported file patterns:
\describe{
  \item{\code{"sex"}}{Files with names containing \code{"11.xls"} or \code{"01_1.xls"}.}
  \item{\code{"place"}}{Files with names containing \code{"02_1.xls"}.}
}
}
\keyword{internal}
