% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hmr.R
\name{plot.hmr}
\alias{plot.hmr}
\title{Generic plot function for hmr object in jarbes.}
\usage{
\method{plot}{hmr}(
  x,
  x.lim = c(-5, 2.8),
  y.lim = c(-2, 1),
  x.lab = "Event rate of The Control Group (logit scale)",
  y.lab = "No improvement <- Effectiveness -> Improvement",
  title.plot = "HMR: Effectiveness Against Baseline Risk",
  AD.colour = "red",
  IPD.colour = "blue",
  Study.Types = c("AD-RCTs", "IPD-RWD"),
  ...
)
}
\arguments{
\item{x}{The object generated by the hmr function.}

\item{x.lim}{Numeric vector of length 2 specifying the x-axis limits.}

\item{y.lim}{Numeric vector of length 2 specifying the y-axis limits.}

\item{x.lab}{Text with the label of the x-axis.}

\item{y.lab}{Text with the label of the y-axis.}

\item{title.plot}{Text for setting a title in the plot.}

\item{AD.colour}{Colour of the location of the baseline risk of the aggregated data AD}

\item{IPD.colour}{Colour of the location of the baseline risk of the individual participant data (IPD) data}

\item{Study.Types}{Vector of text for the label of the study types}

\item{...}{\dots}
}
\description{
Generic plot function for hmr object in jarbes.
}
