% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{healingipd}
\alias{healingipd}
\title{Individual participant data for diabetic patients}
\format{
A dataframe with 260 rows and 18 columns. Each row represents a patient,
the columns are:
   \describe{
    \item{healing.without.amp}{Outcome variable: Healing without amputation with in one year.}
    \item{duration_lesion_days}{Duration of leasions in days at baseline.}
    \item{PAD}{Peripheral arterial disease yes/no.}
    \item{neuropathy}{Neuropathy yes/no.}
    \item{first.ever.lesion}{First ever lesion yes/no.}
    \item{no.continuous.care}{No continuous care yes/no.}
    \item{male}{yes/no.}
    \item{diab.typ2}{Diabetes type 2 yes/no.}
    \item{insulin}{Insulin dependent yes/no.}
    \item{HOCHD}{HOCHD yes/no.}
    \item{HOS}{HOCHD yes/no.}
    \item{CRF}{CRF yes/no.}
    \item{dialysis}{Dialysis yes/no.}
    \item{DNOAP}{DNOAP yes/no.}
    \item{smoking.ever}{Ever smoke yes/no.}
    \item{age}{Age at baseline in years.}
    \item{diabdur}{Diabetes duration at baseline.}
    \item{wagner.class}{Wagner score 1-2 vs. 3-4-5.}
                }
}
\source{
Morbach, S, et al. (2012). Long-Term Prognosis of Diabetic Foot Patients and Their Limbs: Amputation and death over the course of a decade,Diabetes Care, 35, 10, 2012-2017.
}
\description{
Prospective cohort study.
}
\references{
Verde, P.E. (2018) The Hierarchical Meta-Regression Approach and Learning from Clinical Evidence. Technical Report.
}
\keyword{datasets}
