% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{summarize}
\alias{summarize}
\alias{summarize.ir}
\alias{summarise}
\alias{summarise.ir}
\title{Summarize each group in a \code{ir} object to fewer rows}
\source{
\code{\link[dplyr:summarise]{dplyr::summarize()}}
}
\usage{
summarize.ir(.data, ..., .groups = NULL)

summarise.ir(.data, ..., .groups = NULL)
}
\arguments{
\item{.data}{An object of class \code{ir}.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Name-value pairs of summary
functions. The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A vector of length \code{n}, e.g. \code{quantile()}.
\item A data frame, to add multiple columns from a single expression.
}}

\item{.groups}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Grouping structure of the result.
\itemize{
\item "drop_last": dropping the last level of grouping. This was the
only supported option before version 1.0.0.
\item "drop": All levels of grouping are dropped.
\item "keep": Same grouping structure as \code{.data}.
\item "rowwise": Each row is its own group.
}

When \code{.groups} is not specified, it is chosen
based on the number of rows of the results:
\itemize{
\item If all the results have 1 row, you get "drop_last".
\item If the number of rows varies, you get "keep".
}

In addition, a message informs you of that choice, unless the result is ungrouped,
the option "dplyr.summarise.inform" is set to \code{FALSE},
or when \code{summarise()} is called from a function in a package.}
}
\value{
\code{.data} with summarized columns. If the \code{spectra} column is dropped
or invalidated (see \code{\link[=ir_new_ir]{ir_new_ir()}}), the \code{ir} class is dropped, else the
object is of class \code{ir}.
}
\description{
Summarize each group in a \code{ir} object to fewer rows
}
\examples{
## summarize

# select in each sample_type groups the first spectrum
ir_sample_data \%>\%
  dplyr::group_by(sample_type) \%>\%
  dplyr::summarize(spectra = spectra[[1]])


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate-joins}},
\code{\link{mutate}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
