% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir.R
\name{ir_as_ir}
\alias{ir_as_ir}
\alias{ir_as_ir.ir}
\alias{ir_as_ir.data.frame}
\title{Generic to convert objects to class \code{ir}}
\usage{
ir_as_ir(x, ...)

\method{ir_as_ir}{ir}(x, ...)

\method{ir_as_ir}{data.frame}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Further arguments passed to individual methods.
\itemize{
\item If \code{x} is a data frame or an object of class \code{ir}, these are
ignored.
}}
}
\value{
An object of class \code{ir}.
}
\description{
\code{ir_as_ir} ir the generic to convert an object to an object of class
\code{\link[=ir_new_ir]{ir}}.
}
\examples{
# conversion from an ir object
ir::ir_sample_data \%>\%
  ir_as_ir()

# conversion from a data frame
x_ir <- ir::ir_sample_data

x_df <-
  x_ir \%>\%
  ir_drop_spectra() \%>\%
  dplyr::mutate(
    spectra = x_ir$spectra
  ) \%>\%
  ir_as_ir()

# check that ir_as_ir preserves the input class
ir_sample_data \%>\%
  structure(class = setdiff(class(.), "ir")) \%>\%
  dplyr::group_by(sample_type) \%>\%
  ir_as_ir()


}
