% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rdb.R
\name{read_rdb}
\alias{read_rdb}
\title{Read USGS RDB file}
\usage{
read_rdb(file, na_strings = "")
}
\arguments{
\item{file}{'character' string.
Path to file which the data are to be read from.}

\item{na_strings}{'character' vector.
Strings which are interpreted as \code{NA} values.}
}
\value{
A data frame containing a representation of the data in the file.
}
\description{
Reads a RDB (Relational Database) file in table format and creates a data frame from it.
The USGS (U.S. Geological Survey) RDB file is a variant of a tab-delimited ASCII file structure.
}
\examples{
file <- system.file("extdata", "test.rdb", package = "inldata")
d <- read_rdb(file)
str(d)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
