% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.sf}
\alias{gg.sf}
\title{Geom helper for sf objects}
\usage{
\method{gg}{sf}(data, mapping = NULL, ..., geom = "sf")
}
\arguments{
\item{data}{An \code{sf} object.}

\item{mapping}{Default mapping is \code{ggplot2::aes(geometry = ...)},
where the geometry name is obtained from \code{attr(data, "sf_column")}.
This is merged with the user supplied mapping.}

\item{...}{Arguments passed on to \code{geom_sf} or \code{geom_tile}.}

\item{geom}{Either "sf" (default) or "tile". For "tile", uses
\code{geom_tile(..., stat = "sf_coordinates")}, intended for converting point data
to grid tiles with the \code{fill} aesthetic, which is by default set to the first
data column.}
}
\value{
A ggplot return value
}
\description{
This function uses \code{geom_sf()}, unless overridden by the geom argument.
Requires the \code{ggplot2} package.
}
\examples{
\donttest{
  if (require("ggplot2", quietly = TRUE) &&
      requireNamespace("terra", quietly = TRUE) &&
      require("tidyterra", quietly = TRUE)) {
    # Load Gorilla data

    gorillas <- inlabru::gorillas_sf
    gorillas$gcov <- gorillas_sf_gcov()

    # Plot Gorilla elevation covariate provided as terra::rast.

    ggplot() +
      gg(gorillas$gcov$elevation)

    # Add Gorilla survey boundary and nest sightings

    ggplot() +
      gg(gorillas$gcov$elevation) +
      gg(gorillas$boundary, alpha = 0) +
      gg(gorillas$nests)

    # Load pantropical dolphin data

    mexdolphin <- inlabru::mexdolphin_sf

    # Plot the pantropical survey boundary, ship transects and dolphin sightings

    ggplot() +
      gg(mexdolphin$ppoly, alpha = 0.5) + # survey boundary
      gg(mexdolphin$samplers) + # ship transects
      gg(mexdolphin$points) # dolphin sightings

    # Change color

    ggplot() +
      gg(mexdolphin$ppoly, color = "green", alpha = 0.5) + # survey boundary
      gg(mexdolphin$samplers, color = "red") + # ship transects
      gg(mexdolphin$points, color = "blue") # dolphin sightings


    # Visualize data annotations: line width by segment number

    names(mexdolphin$samplers) # 'seg' holds the segment number
    ggplot() +
      gg(mexdolphin$samplers, aes(color = seg))

    # Visualize data annotations: point size by dolphin group size

    names(mexdolphin$points) # 'size' holds the group size
    ggplot() +
      gg(mexdolphin$points, aes(size = size))
  }
}
}
\seealso{
Other geomes for spatial data: 
\code{\link{gg}()},
\code{\link{gg.SpatRaster}()},
\code{\link{gg.SpatialGridDataFrame}()},
\code{\link{gg.SpatialLines}()},
\code{\link{gg.SpatialPixels}()},
\code{\link{gg.SpatialPixelsDataFrame}()},
\code{\link{gg.SpatialPoints}()},
\code{\link{gg.SpatialPolygons}()}
}
\concept{geomes for spatial data}
