% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper}
\alias{bru_mapper}
\alias{bru_mapper_define}
\title{Constructors for \code{bru_mapper} objects}
\usage{
bru_mapper(...)

bru_mapper_define(mapper, new_class = NULL, ...)
}
\arguments{
\item{\dots}{Arguments passed on to sub-methods, or used for special
purposes, see details for each function below.}

\item{mapper}{For \code{bru_mapper_define}, a prototype mapper object, see
Details. For \code{bru_mapper_scale}, a mapper to be scaled.}

\item{new_class}{If non-\code{NULL}, this is added at the front of the class
definition}
}
\value{
\itemize{
\item \code{bru_mapper()} returns a \code{bru_mapper} object
}
}
\description{
Constructors for \code{bru_mapper} objects
}
\section{Functions}{
\itemize{
\item \code{bru_mapper()}: Generic mapper S3 constructor, used for constructing
mappers for special objects. See below for details of the
default constructor \code{\link[=bru_mapper_define]{bru_mapper_define()}} that can be used to define
new mappers in user code.

\item \code{bru_mapper_define()}: Adds the \code{new_class} and "bru_mapper" class names to
the inheritance list for the input \code{mapper} object, unless the object
already inherits from these.

To register mapper classes and methods in scripts, use \code{.S3method()}
to register the methods, e.g.
\code{.S3method("ibm_jacobian", "my_mapper_class", ibm_jacobian.my_mapper_class)}.

In packages with \code{Suggests: inlabru}, add method information for delayed
registration, e.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' @rawNamespace S3method(inlabru::bru_get_mapper, inla_rspde)
#' @rawNamespace S3method(inlabru::ibm_n, bru_mapper_inla_rspde)
#' @rawNamespace S3method(inlabru::ibm_values, bru_mapper_inla_rspde)
#' @rawNamespace S3method(inlabru::ibm_jacobian, bru_mapper_inla_rspde)
}\if{html}{\out{</div>}}

or before each method, use \verb{@exportS3Method}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' @exportS3Method inlabru::bru_get_mapper
}\if{html}{\out{</div>}}

etc., which semi-automates it.

}}
\examples{
mapper <- bru_mapper_index(5)
ibm_jacobian(mapper, input = c(1, 3, 4, 5, 2))
}
\seealso{
\link{bru_mapper_generics} for generic methods,
the individual mapper pages for special method implementations, and
\link{bru_get_mapper} for hooks to extract mappers from latent model object
class objects.

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_fmesher}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_repeat}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
