% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-utility.R
\name{geomCV}
\alias{geomCV}
\title{Compute geometric coefficient of variation 
(in a scale from 0 to 100).}
\usage{
geomCV(x, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector.}

\item{na.rm}{Logical, should NA value(s) be removed (FALSE by default)?}
}
\value{
Numeric vector of length 1 with 
geometric coefficient of variation.
}
\description{
The geometric coefficient of variation is computed as:
\eqn{\sqrt{\exp(\sigma(log(x))^2)-1}*100}, with:
\itemize{
\item{log: natural logarithm}
\item{\eqn{\sigma}: standard deviation}
}
}
\examples{
# Geometric coefficient of variation of a sample from a log normal distribution:
geomCV(rlnorm(n = 1000, meanlog = 0, sdlog = 1))
}
\seealso{
Other stats utility functions: 
\code{\link{cv}()},
\code{\link{geomMean}()},
\code{\link{geomSD}()},
\code{\link{geomSE}()},
\code{\link{se}()}
}
\author{
Laure Cougnaud
}
\concept{stats utility functions}
