% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_repertoires.R
\name{load_repertoires}
\alias{load_repertoires}
\title{Load and Aggregate Immune Receptor Repertoire Data}
\usage{
load_repertoires(
  path,
  schema,
  metadata = NULL,
  barcode_col = NULL,
  count_col = NULL,
  repertoire_schema = NULL,
  output_folder = NULL,
  enforce_schema = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{path}{Path to an input file. This file may be Parquet, CSV, or TSV. The file extension is
automatically detected and handled.}

\item{schema}{Character vector defining which columns in the input data should be used to
identify unique receptor signatures. For example, \code{c("V_gene", "J_gene", "CDR3_nt")}.}

\item{metadata}{An optional data frame containing additional metadata to merge into the annotation table.
Default is \code{NULL}.}

\item{barcode_col}{An optional character string specifying the column in the input data that represents
cell barcodes or other unique identifiers. Default is \code{NULL}.}

\item{count_col}{An optional character string specifying the column in the input data that stores
bulk receptor counts. Default is \code{NULL}.}

\item{repertoire_schema}{An optional character vector defining how annotations should be grouped into repertoires
(for example, \code{c("sample", "donor")}). Currently unused in this function, but reserved
for future expansions. Default is \code{NULL}.}

\item{output_folder}{Character string specifying the directory to save the resulting Parquet files. If \code{NULL},
a folder named \verb{immundata-<basename_of_path>} is created in the same directory as \code{path}.}

\item{enforce_schema}{Logical. If \code{TRUE}, column names and types must strictly match between files. If \code{FALSE},
columns are unioned}

\item{verbose}{.  Logical. Not used -- for now.}
}
\description{
This function ingests a repertoire dataset (Parquet, CSV, or TSV), aggregates receptors
based on a user-defined schema, and splits the result into receptor-level and annotation-level
tables. The resulting data is saved to a designated output folder as two Parquet files
(receptors and annotations) and then reloaded to create an \code{ImmunData} object.
}
\details{
\enumerate{
\item \strong{Reading} – The function automatically detects whether \code{path} points
to a Parquet, CSV, or TSV file, using \code{read_parquet_duckdb} or \code{read_csv_duckdb}.
\item \strong{Aggregation} – Receptor uniqueness is determined by the columns named in
\code{schema}, while barcodes or counts are handled depending on which parameters
(\code{barcode_col}, \code{count_col}) are provided.
\item \strong{Saving} – The final receptor-level and annotation-level tables are written
to Parquet files in \code{output_folder}.
\item \strong{Reloading} – The function calls \code{\link[=load_immundata]{load_immundata()}} on the newly
created folder to return a fully instantiated \code{ImmunData}.
}
}
\seealso{
\code{\link[=load_immundata]{load_immundata()}}, \link{ImmunData}
}
