% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriche}
\alias{deriche}
\title{Apply recursive Deriche filter.}
\usage{
deriche(im, sigma, order = 0L, axis = "x", neumann = FALSE)
}
\arguments{
\item{im}{an image}

\item{sigma}{Standard deviation of the filter.}

\item{order}{Order of the filter. 0 for a smoothing filter, 1 for first-derivative, 2 for second.}

\item{axis}{Axis along which the filter is computed ( 'x' , 'y', 'z' or 'c').}

\item{neumann}{If true, use Neumann boundary conditions (default false, Dirichlet)}
}
\description{
The Deriche filter is a fast approximation to a Gaussian filter (order = 0), or Gaussian derivatives (order = 1 or 2).
}
\examples{
\dontshow{cimg.limit.openmp()}
deriche(boats,sigma=2,order=0) \%>\% plot("Zeroth-order Deriche along x")
deriche(boats,sigma=2,order=1) \%>\% plot("First-order Deriche along x")
deriche(boats,sigma=2,order=1) \%>\% plot("Second-order Deriche along x")
deriche(boats,sigma=2,order=1,axis="y") \%>\% plot("Second-order Deriche along y")
}
