% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im.ridgeline.R
\name{im.ridgeline}
\alias{im.ridgeline}
\title{Generate Ridgeline Plots from Satellite Raster Data}
\usage{
im.ridgeline(
  im,
  scale,
  palette = c("viridis", "magma", "plasma", "inferno", "cividis", "mako", "rocket",
    "turbo")
)
}
\arguments{
\item{im}{A `SpatRaster` object representing the raster data to be visualized.}

\item{scale}{A numeric value that defines the vertical scale of the ridgeline plot.}

\item{palette}{A character string specifying the `viridis` color palette option to use.
Available options: `"viridis"`, `"magma"`, `"plasma"`, `"inferno"`, `"cividis"`, `"mako"`, `"rocket"`, `"turbo"`.}
}
\value{
A `ggplot` object displaying the ridgeline plot.
}
\description{
This function generates ridgeline plots from stacked satellite imagery data.
}
\details{
Ridgeline plots are useful for analyzing temporal variations in raster-based satellite imagery.
This function extracts raster values and visualizes their distribution across layers.
}
\examples{
library(terra)
library(ggridges)
library(ggplot2)

# Create a 5-layer raster
r <- rast(nrows = 10, ncols = 10, nlyrs = 5)
values(r) <- runif(ncell(r) * 5)

# Generate ridgeline plot
im.ridgeline(r, scale = 2, palette = "viridis") + theme_minimal()
}
\references{
See also `im.import()`, `im.ggplot()`.
}
\seealso{
[GitHub Repository](https://github.com/ducciorocchini/imageRy/)
}
