% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifo.R
\name{ifo_business}
\alias{ifo_business}
\title{Return ifo business climate data}
\source{
\url{https://www.ifo.de/en/ifo-time-series}
}
\usage{
ifo_business(
  type = c("germany", "sectors", "eastern", "saxony"),
  long_format = TRUE
)
}
\arguments{
\item{type}{(\code{character(1)}) Defaults to \code{"germany"}. One of:
\itemize{
\item \code{"germany"}: returns the ifo business climate index for Germany.
\item \code{"sectors"}: returns the ifo business climate index for different sectors.
\item \code{"eastern"}: returns the ifo business climate index for eastern Germany.
\item \code{"saxony"}: returns the ifo business climate index for Saxony.
}}

\item{long_format}{(\code{logical(1)}) If \code{TRUE} return the data in long format.
Only applies to \code{type} \code{"germany"} and \code{"sectors"}. Default \code{TRUE}.}
}
\value{
A \code{data.frame()} containing the monthly ifo business climate time series.
}
\description{
Return ifo business climate data
}
\examples{
\donttest{
ifo_business("germany")
}
}
\seealso{
The \href{https://m-muecke.github.io/ifo/articles/publication.html}{article} for
a reproducible example.
}
