% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-lookup.R
\name{occupied}
\alias{occupied}
\title{Faces occupied by the specified object}
\usage{
occupied(gridObj, data, out = "logical", ...)
}
\arguments{
\item{gridObj}{(\code{\link{trigrid}} or \code{\link{hexagrid}}) An icoshedral grid.}

\item{data}{(\code{matrix}, \code{data.frame}, \code{sf} or \code{Spatial}) The queried data.}

\item{out}{(\code{character}) What shall be the output class? Can be either \code{\link{facelayer}} or \code{logical} (default.)}

\item{...}{Arguments passed to the class specific methods}
}
\value{
The function Returns a \code{\link{facelayer}}-class object.
}
\description{
This function will return a \code{\link{facelayer}} class object showing which faces are occupied by the input object.
}
\details{
This is a wrapper function on the \code{OccupiedFaces} methods that are specific to grid class and input data.
}
\examples{
# create a grid
g <- trigrid(8, sf=TRUE)

# create random points
randPoints <- rpsphere(100,output="polar")

# the faces occupied by these points
occ <- occupied(g, randPoints)
 
 # plot using sf slot independently
plot(g@sf[occ,"geometry"])
points(randPoints, col="red", pch="+")


}
