% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seg.R
\name{zsegarray}
\alias{zsegarray}
\title{Zygote segregation distributions.}
\usage{
zsegarray(alpha, ploidy)
}
\arguments{
\item{alpha}{A numeric vector containing the double reduction parameter(s).
This should be a
vector of length \code{floor(ploidy/4)} where \code{alpha[i]}
is the probability of exactly \code{i} pairs of IBDR alleles
being in the gamete. Note that \code{sum(alpha)} should be less than
1, as \code{1 - sum(alpha)} is the probability of no double reduction.}

\item{ploidy}{The ploidy of the species. This should be an even positive
integer.}
}
\value{
An array of probabilities. Element (i, j, k) contains the
probability of offspring dosage k-1 given parental dosages
i-1 and j-1.
}
\description{
Obtains offspring genotype probabilities given parental probabilities,
the ploidy of the species, and the overdispersion parameter,
for all possible parental genotypes.
}
\examples{
ploidy <- 10
alpha <- c(0.5, 0.1)
p1 <- 4
p2 <- 3
segarray <- zsegarray(alpha = alpha, ploidy = ploidy)
graphics::plot(x = 0:10,
               y = segarray[p1 + 1, p2 + 1, ],
               type = "h",
               ylab = "Pr(dosage)",
               xlab = "dosage")
graphics::mtext(paste0("P1 dosage = ",
                       p1,
                       ", ",
                       "P2 dosage = ",
                       p2))

}
\author{
David Gerard
}
