% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-perform-connection.R
\name{req_perform_connection}
\alias{req_perform_connection}
\title{Perform a request and return a streaming connection}
\usage{
req_perform_connection(
  req,
  blocking = TRUE,
  verbosity = NULL,
  mock = getOption("httr2_mock", NULL)
)
}
\arguments{
\item{req}{A httr2 \link{request} object.}

\item{blocking}{When retrieving data, should the connection block and wait
for the desired information or immediately return what it has (possibly
nothing)?}

\item{verbosity}{How much information to print? This is a wrapper
around \code{\link[=req_verbose]{req_verbose()}} that uses an integer to control verbosity:
\itemize{
\item \code{0}: no output
\item \code{1}: show headers
\item \code{2}: show headers and bodies as they're streamed
\item \code{3}: show headers, bodies, curl status messages, raw SSEs, and stream
buffer management
}

Use \code{\link[=with_verbosity]{with_verbosity()}} to control the verbosity of requests that
you can't affect directly.}

\item{mock}{A mocking function. If supplied, this function is called
with the request. It should return either \code{NULL} (if it doesn't want to
handle the request) or a \link{response} (if it does). See
\code{\link[=with_mocked_responses]{with_mocked_responses()}}/\code{local_mocked_responses()} for more details.}
}
\description{
Use \code{req_perform_connection()} to perform a request if you want to stream the
response body. A response returned by \code{req_perform_connection()} includes a
connection as the body. You can then use \code{\link[=resp_stream_raw]{resp_stream_raw()}},
\code{\link[=resp_stream_lines]{resp_stream_lines()}}, or \code{\link[=resp_stream_sse]{resp_stream_sse()}} to retrieve data a chunk at a
time. Always finish up by closing the connection by calling
\code{close(response)}.

This is an alternative interface to \code{\link[=req_perform_stream]{req_perform_stream()}} that returns a
\link[base:connections]{connection} that you can use to pull the data, rather
than providing callbacks that the data is pushed to. This is useful if you
want to do other work in between handling inputs from the stream.
}
\examples{
req <- request(example_url()) |>
  req_url_path("/stream-bytes/32768")
resp <- req_perform_connection(req)

length(resp_stream_raw(resp, kb = 16))
length(resp_stream_raw(resp, kb = 16))
# When the stream has no more data, you'll get an empty result:
length(resp_stream_raw(resp, kb = 16))

# Always close the response when you're done
close(resp)

# You can loop until complete with resp_stream_is_complete()
resp <- req_perform_connection(req)
while (!resp_stream_is_complete(resp)) {
  print(length(resp_stream_raw(resp, kb = 12)))
}
close(resp)
}
