% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_gfr.R
\name{estimate_gfr}
\alias{estimate_gfr}
\title{Predict GFR.}
\usage{
estimate_gfr(gfrtmp.dt, gfr_resid_var = TRUE, ckd_epi_race_coeff = FALSE)
}
\arguments{
\item{gfrtmp.dt}{A data.table with columns \code{gender}, \code{reth}, 
\code{age_years}, \code{age_months}, \code{BSA_adj}, \code{serum_creat}.}

\item{gfr_resid_var}{Logical value indicating whether or not to include
residual variability when generating GFR values. (Default is TRUE.)}

\item{ckd_epi_race_coeff}{Logical value indicating whether or not to use the
"race coefficient" from the CKD-EPI equation when estimating GFR values.
(Default is FALSE.)}
}
\value{
The same data.table with a \code{gfr_est} column added, containing 
 estimated GFR values.
}
\description{
Predict GFR using CKD-EPI equation (for adults) or BSA-based equation (for children).
}
\details{
Add residual variability based on reported residuals for each equation.
}
\references{
\insertRef{ring2017identifying}{httk}
}
\author{
Caroline Ring
}
\keyword{httk-pop}
