% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_elimination_rate.R
\name{calc_elimination_rate}
\alias{calc_elimination_rate}
\title{Calculate the elimination rate for a one compartment model}
\usage{
calc_elimination_rate(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  species = "Human",
  model = "3compartmentss",
  suppress.messages = TRUE,
  ...
)
}
\arguments{
\item{chem.cas}{Either the cas number or the chemical name must be
specified.}

\item{chem.name}{Either the chemical name or the cas number must be
specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_steadystate or
1compartment function, overrides chem.name and chem.cas.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{model}{The model used to calculate total clearance (defaults to "3compartmentss")}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{...}{Additional parameters passed to parameterize function if 
parameters is NULL.}
}
\value{
\item{Elimination rate}{Units of 1/h.}
}
\description{
This function calculates an elimination rate from the three compartment
steady state model where elimination is entirely due to metablism by the
liver and glomerular filtration in the kidneys.
}
\details{
Elimination rate calculated by dividing the total clearance (using the
default -stirred hepatic model) by the volume of distribution. When
species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitues human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.
}
\examples{

calc_elimination_rate(chem.name="Bisphenol A")

\dontrun{

calc_elimination_rate(chem.name="Bisphenol A",species="Rat")

# non-restrictive clearance should be faster:
kelim1 <- calc_elimination_rate(chem.cas="80-05-7")
kelim2 <- calc_elimination_rate(chem.cas="80-05-7", 
                                restrictive.clearance=FALSE)
if (!(kelim2 > kelim1)) stop("kelim2 is not faster than kelim1")
}

}
\references{
\insertRef{schmitt2008general}{httk}

\insertRef{dawson2021qsar}{httk} 

\insertRef{kilford2008hepatocellular}{httk}
}
\seealso{
\code{\link{calc_total_clearance}} for calculation of total clearance

\code{\link{calc_vdist}} for calculation of volume of distribution
}
\author{
John Wambaugh
}
\keyword{1compartment}
\keyword{Parameter}
