% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_loss.R
\name{average_loss}
\alias{average_loss}
\alias{average_loss.default}
\alias{average_loss.ranger}
\alias{average_loss.explainer}
\title{Average Loss}
\usage{
average_loss(object, ...)

\method{average_loss}{default}(
  object,
  X,
  y,
  pred_fun = stats::predict,
  loss = "squared_error",
  agg_cols = FALSE,
  BY = NULL,
  by_size = 4L,
  w = NULL,
  ...
)

\method{average_loss}{ranger}(
  object,
  X,
  y,
  pred_fun = function(m, X, ...) stats::predict(m, X, ...)$predictions,
  loss = "squared_error",
  agg_cols = FALSE,
  BY = NULL,
  by_size = 4L,
  w = NULL,
  ...
)

\method{average_loss}{explainer}(
  object,
  X = object[["data"]],
  y = object[["y"]],
  pred_fun = object[["predict_function"]],
  loss = "squared_error",
  agg_cols = FALSE,
  BY = NULL,
  by_size = 4L,
  w = object[["weights"]],
  ...
)
}
\arguments{
\item{object}{Fitted model object.}

\item{...}{Additional arguments passed to \code{pred_fun(object, X, ...)},
for instance \code{type = "response"} in a \code{\link[=glm]{glm()}} model, or \code{reshape = TRUE} in a
multiclass XGBoost model.}

\item{X}{A data.frame or matrix serving as background dataset.}

\item{y}{Vector/matrix of the response, or the corresponding column names in \code{X}.}

\item{pred_fun}{Prediction function of the form \verb{function(object, X, ...)},
providing \eqn{K \ge 1} predictions per row. Its first argument represents the
model \code{object}, its second argument a data structure like \code{X}. Additional arguments
(such as \code{type = "response"} in a GLM, or \code{reshape = TRUE} in a multiclass XGBoost
model) can be passed via \code{...}. The default, \code{\link[stats:predict]{stats::predict()}}, will work in
most cases.}

\item{loss}{One of "squared_error", "logloss", "mlogloss", "poisson",
"gamma", or "absolute_error". Alternatively, a loss function
can be provided that turns observed and predicted values into a numeric vector or
matrix of unit losses of the same length as \code{X}.
For "mlogloss", the response \code{y} can either be a dummy matrix or a discrete vector.
The latter case is handled via a fast version of \code{model.matrix(~ as.factor(y) + 0)}.
For "squared_error", the response can be a factor with levels in column order of
the predictions. In this case, squared error is evaluated for each one-hot-encoded column.}

\item{agg_cols}{Should multivariate losses be summed up? Default is \code{FALSE}.
In combination with the squared error loss, \code{agg_cols = TRUE} gives
the Brier score for (probabilistic) classification.}

\item{BY}{Optional grouping vector or column name.
Numeric \code{BY} variables with more than \code{by_size} disjoint values will be
binned into \code{by_size} quantile groups of similar size.}

\item{by_size}{Numeric \code{BY} variables with more than \code{by_size} unique values will
be binned into quantile groups. Only relevant if \code{BY} is not \code{NULL}.}

\item{w}{Optional vector of case weights. Can also be a column name of \code{X}.}
}
\value{
An object of class "hstats_matrix" containing these elements:
\itemize{
\item \code{M}: Matrix of statistics (one column per prediction dimension), or \code{NULL}.
\item \code{SE}: Matrix with standard errors of \code{M}, or \code{NULL}.
Multiply with \code{sqrt(m_rep)} to get \emph{standard deviations} instead.
Currently, supported only for \code{\link[=perm_importance]{perm_importance()}}.
\item \code{m_rep}: The number of repetitions behind standard errors \code{SE}, or \code{NULL}.
Currently, supported only for \code{\link[=perm_importance]{perm_importance()}}.
\item \code{statistic}: Name of the function that generated the statistic.
\item \code{description}: Description of the statistic.
}
}
\description{
Calculates the average loss of a model on a given dataset,
optionally grouped by a variable. Use \code{plot()} to visualize the results.
}
\section{Methods (by class)}{
\itemize{
\item \code{average_loss(default)}: Default method.

\item \code{average_loss(ranger)}: Method for "ranger" models.

\item \code{average_loss(explainer)}: Method for DALEX "explainer".

}}
\section{Losses}{


The default \code{loss} is the "squared_error". Other choices:
\itemize{
\item "absolute_error": The absolute error is the loss corresponding to median regression.
\item "poisson": Unit Poisson deviance, i.e., the loss function used in
Poisson regression. Actual values \code{y} and predictions must be non-negative.
\item "gamma": Unit gamma deviance, i.e., the loss function of Gamma regression.
Actual values \code{y} and predictions must be positive.
\item "logloss": The Log Loss is the loss function used in logistic regression,
and the top choice in probabilistic binary classification. Responses \code{y} and
predictions must be between 0 and 1. Predictions represent probabilities of
having a "1".
\item "mlogloss": Multi-Log-Loss is the natural loss function in probabilistic multi-class
situations. If there are K classes and n observations, the predictions form
a (n x K) matrix of probabilities (with row-sums 1).
The observed values \code{y} are either passed as (n x K) dummy matrix,
or as discrete vector with corresponding levels.
The latter case is turned into a dummy matrix by a fast version of
\code{model.matrix(~ as.factor(y) + 0)}.
\item A function with signature \code{f(actual, predicted)}, returning a numeric
vector or matrix of the same length as the input.
}
}

\examples{
# MODEL 1: Linear regression
fit <- lm(Sepal.Length ~ ., data = iris)
average_loss(fit, X = iris, y = "Sepal.Length")
average_loss(fit, X = iris, y = iris$Sepal.Length, BY = iris$Sepal.Width)
average_loss(fit, X = iris, y = "Sepal.Length", BY = "Sepal.Width")

# MODEL 2: Multi-response linear regression
fit <- lm(as.matrix(iris[, 1:2]) ~ Petal.Length + Petal.Width + Species, data = iris)
average_loss(fit, X = iris, y = iris[, 1:2])
L <- average_loss(
  fit, X = iris, y = iris[, 1:2], loss = "gamma", BY = "Species"
)
L
plot(L)
}
