% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mplus_esyn.R
\name{Mplus_esyn}
\alias{Mplus_esyn}
\title{Generating Mplus syntax for empirical RIASEC angular locations}
\usage{
Mplus_esyn(
  N,
  Cor,
  name = NULL,
  dummyvorl = 1,
  verbose = FALSE,
  eol = "\\r\\n",
  ...
)
}
\arguments{
\item{N}{number of observations for correlations as numeric}

\item{Cor}{an R matrix object with RIASEC correlations.}

\item{name}{optional a name (as character) for the Mplus syntax to be saved - default is the object name or the name given in paramter \code{Cor} as character (with ending changed to '.inp').}

\item{dummyvorl}{default is dummyvorl = 1, which results in the Mplus syntax given in Nagy et. al. (2009). !! don't change this !!
if changed: \emph{"Alternatively, the name of an external dummy template to be used can also be specified here, which is then read in and used. It is strongly recommended to use the internal syntax template, since the use of an external dummy template cannot be documented further here."}.}

\item{verbose}{logical with default set to \code{verbose=FALSE}; if set to \code{verbose=TRUE} the resulting Mplus syntax is \emph{additionally} printed on the console.}

\item{eol}{character see \code{\link{write.table}} to control the generation of correct line endings in text files on different operating systems.}

\item{...}{additional parameters passed through}
}
\value{
resulting Mplus syntax will be saved in the current working directory
}
\description{
This function generates executable Mplus syntax which is discussed in Nagy et. al. (2009). the resulting Mplus syntax estimates the angular locations of the six RIASEC dimensions, based on their correlations, in the assumed circumplex array within the theory of vocational choice by John Holland (1997).
}
\details{
by default the Mplus syntax file is written in the current working directory.
}
\examples{
# generating an example Mplus syntax refering to a R object 
# with correlation data 
data(example1) # loading fictional example correlation matrix
Mplus_esyn(N = 300, Cor = example1)
## Mplus syntax is now saved in the current workspace
################################################################
### clean up work directory
file.remove("example1.inp") # remove generated Mplus syntax from work dir.
file.remove("example1.dat") # remove generated cor. data from work dir.
}
\references{
Holland, J.L. (1997). \emph{Making vocational choices. A theory of vocational personalities and work environments}. Lutz, FL: Psychological Assessment Resources.

Nagy, G., Marsh, H. W., Luedtke, O., & Trautwein, U. (2009). Representing circles in our minds: Confirmatory factor analysis of circumplex structures and profiles. In T. Teo & M. S. Khine (Hrsg.), \emph{Structural Equation Modeling in Educational Research: Concepts and applications} (S. 287 - 315). Rotterdam Boston Taipei: Sense Publishers.
}
\keyword{calculus}
