% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mplus_epal.R
\name{Mplus_epal}
\alias{Mplus_epal}
\title{Extracting RIASEC and additional construct angular locations from Mplus output}
\usage{
Mplus_epal(target, M, konstrukt = "", ...)
}
\arguments{
\item{target}{name of the Mplus output file name within the working directory as character. May also be a full path or relative path. Example: target = "MyMplus.out"}

\item{M}{number of additional construct dimensions projected into the RIASEC circumplex - e.g. \code{M=5} for big-five personality dimensions}

\item{konstrukt}{optionally a character vector with length = M containing labels for construct dimensions.}

\item{...}{additional parameters passed through}
}
\value{
returns a list object containing the RIASEC and additional construct angular locations extracted from the Mplus output.
}
\description{
This function extracts the empirical RIASEC angular locations and angular locations for the additional (projected) construct from an Mplus output file, which is the result of processing the Mplus syntax generated with the function \code{\link{Mplus_psyn}()}.
}
\details{
This function uses the function \code{readModels()} in package \code{\link[MplusAutomation]{MplusAutomation}}.


more to come
}
\examples{
## generating an example Mplus syntax refering to a R object with correlation data 
data(example1) # loading fictional example correlation matrix
Mplus_esyn(N = 300, Cor = example1)
##### not run until Mplus inputfile example1.inp is processed by Mplus #####
\dontrun{Mplus_epal("example1.out",M=0)}
################################################################
### clean up work directory
file.remove("example1.inp") # remove generated Mplus syntax from work dir.
file.remove("example1.dat") # remove generated cor. data from work dir.
}
\references{
Holland, J.L. (1997). \emph{Making vocational choices. A theory of vocational personalities and work environments}. Lutz, FL: Psychological Assessment Resources.

Nagy, G., Marsh, H. W., Luedtke, O., & Trautwein, U. (2009). Representing circles in our minds: Confirmatory factor analysis of circumplex structures and profiles. In T. Teo & M. S. Khine (Hrsg.), \emph{Structural Equation Modeling in Educational Research: Concepts and applications} (S. 287 - 315). Rotterdam Boston Taipei: Sense Publishers.
}
\keyword{calculus}
