% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{collect_emulators}
\alias{collect_emulators}
\title{Collect and order emulators}
\usage{
collect_emulators(
  emulators,
  targets = NULL,
  cutoff = 3,
  ordering = c("params", "imp", "volume"),
  sample_size = 200,
  ...
)
}
\arguments{
\item{emulators}{The recursive list of emulators}

\item{targets}{If not NULL, uses implausibility to order the emulators.}

\item{cutoff}{The implausibility cutoff to use (if required)}

\item{ordering}{The order in which to apply the relevant metrics}

\item{sample_size}{The number of points to apply implausibility to (if required)}

\item{...}{Any additional arguments to pass recursively to collect_emulators}
}
\value{
A list of emulators with the ordered property described above.
}
\description{
Manipulates lists (or lists of lists) of emulators into a useable form.
}
\details{
Most often used as a pre-processing stage for \code{generate_new_design} or
\code{nth_implausible}, this takes a list of emulators in a variety of forms
coming from either multiple waves of history matching, hierarchical emulation
or bimodal emulation, and arrange them in a form suitable for sequential analysis.
Emulators are also ordered by a number of factors: number of parameters, size of
the minimum enclosing hyperrectangle, and implausibility (where applicable).

If targets are provided, then the emulators can also be tested on the basis of
how restrictive they are: this is included in the ordering. The cutoff by which to
make a determination of implausibility for a point is governed by \code{cutoff}.
The number of points to sample to consider implausibility is chosen by the value
of \code{sample_size}: higher values are likely to be a more accurate reflection
but will take longer.

The weighting of each of the three metrics can be chosen using the \code{ordering}
argument: metrics with higher weight are closer to the front of the character vector.
The metrics are denoted "params" for number of parameters, "imp" for restrictiveness,
and "volume" for volume of the hyperrectangle. For instance, a character vector
\code{c("volume", "imp")} would sort first by volume of the minimum enclosing hyperrectangle,
resolve ties by restrictiveness, and not consider the number of parameters.
}
